<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GSAdjustment extends Model
{
    protected $table = 'gs_adjustments';

    protected $fillable = [
        'item_id',
        'old_qty',
        'actual_qty',
        'diff_qty',
        'reason',
        'adjusted_by',
        'adjusted_at',
    ];

    protected $casts = [
        'old_qty'     => 'decimal:3',
        'actual_qty'  => 'decimal:3',
        'diff_qty'    => 'decimal:3',
        'adjusted_at' => 'datetime',
    ];

    // Relations (optional; enable if related models exist)
    public function item()
    {
        return $this->belongsTo(\App\Models\Item::class, 'item_id');
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'adjusted_by');
    }
}

