<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FinishProductTransfer extends Model
{
    use HasFactory;

    // ✅ Use the same table as Raw Material Transfers
    protected $table = 'rmstock_transfers';

    protected $fillable = [
        'from_warehouse_id',
        'to_warehouse_id',
        'date',
        'transfer_cost',
        'total_kg',
        'total_bag',
        'grand_total_kg',
        'status',
        'type', // if you use a column to differentiate raw/finish
    ];

    protected $casts = [
        'date' => 'date',
        'transfer_cost' => 'decimal:2',
    ];

    public function items()
    {
        return $this->hasMany(FinishProductTransferItem::class, 'transfer_id');
    }
}

