<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FinishBagAdjustment extends Model
{
    protected $table = 'finish_bag_adjustments';

    protected $fillable = [
        'company_id',
        'warehouse_id',
        'date',
        'total_qty',
        'total_value',
        'note',
    ];

    protected $casts = [
        'date'        => 'date',
        'total_qty'   => 'decimal:2',
        'total_value' => 'decimal:2',
    ];

    public function company()   { return $this->belongsTo(Company::class); }
    public function warehouse() { return $this->belongsTo(Warehouse::class); }

    // If you created items table:
    public function items()
    {
        return $this->hasMany(FinishBagAdjustmentItem::class);
    }
}
