<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FinishBag extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'warehouse_id',
        'opening_quantity',
        'alert_quantity',
        'price',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'opening_quantity' => 'decimal:2',
        'alert_quantity'   => 'decimal:2',
        'price'            => 'decimal:2',
        'status'           => 'boolean',
    ];

    public function warehouse()
    {
        return $this->belongsTo(\App\Models\Warehouse::class);
    }
}

