<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Customer extends Model
{
    protected $table = 'rm_customers';

    protected $fillable = [
        'name','customerId','account_id','company_name','personal_phone','bussiness_phone',
        'email','address','opening_balance','current_balance','due_limit','remarks',
        'customer_type','executive_name','area_id','employee_id','discount_type',
        'discount','assume_rate','image','status','created_by','updated_by','party_type_id',
    ];

    /**
     * After create, write formatted customerId if missing.
     * Format: CO + 4-digit left-padded id (e.g. CO0001)
     */
    protected static function booted(): void
    {
        static::created(function (Customer $c) {
            if (empty($c->customerId)) {
                $c->customerId = 'CO' . str_pad((string) $c->id, 4, '0', STR_PAD_LEFT);
                $c->saveQuietly(); // avoids recursion
            }
        });
    }

    /**
     * Convenience accessor: $customer->id_code
     * Always returns a displayable code, even if old rows have NULL customerId.
     */
    protected function idCode(): Attribute
    {
        return Attribute::get(
            fn () => $this->customerId ?: ('CO' . str_pad((string) $this->id, 4, '0', STR_PAD_LEFT))
        );
    }

    // (Add relations if you need them later, e.g. area(), etc.)
}