<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Business extends Model
{
    use SoftDeletes;

    protected $fillable = ['name','owner_id','subdomain','domain','timezone','is_active'];
    protected $casts = ['is_active'=>'boolean'];

    public function owner() { return $this->belongsTo(User::class, 'owner_id'); }
    public function users() { return $this->belongsToMany(User::class)->withTimestamps()->withPivot('role'); }
    public function subscription() { return $this->hasOne(Subscription::class)->latestOfMany(); }
}
