<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BagExchange extends Model
{
    use SoftDeletes; // remove if you don't have a deleted_at column

    /** Table name (change if yours is different) */
    protected $table = 'bag_exchanges';

    /** Allow mass assignment for form fields */
    protected $fillable = [
        'warehouse_id',
        'date',
        'bag_warehouse_id',
        'ex_warehouse_id',
        'product_id',
        'ex_product_id',
        'finish_bag_id',
        'ex_finish_bag_id',
        'product_stock_kg',
        'total_kg',
        'status',
        'remarks',     // keep if you have this column
        'reference',   // keep if you have this column
        'type',        // keep if you have this column
        'created_by',
        'updated_by',
    ];

    /** Useful casts */
    protected $casts = [
        'date'             => 'date',
        'product_stock_kg' => 'decimal:3',
        'total_kg'         => 'decimal:3',
        'status'           => 'integer',
        'warehouse_id'     => 'integer',
        'bag_warehouse_id' => 'integer',
        'ex_warehouse_id'  => 'integer',
        'product_id'       => 'integer',
        'ex_product_id'    => 'integer',
        'finish_bag_id'    => 'integer',
        'ex_finish_bag_id' => 'integer',
        'created_by'       => 'integer',
        'updated_by'       => 'integer',
    ];

    /* ---------- (optional) relationships ---------- */
    public function warehouse()     { return $this->belongsTo(\App\Models\Warehouse::class, 'warehouse_id'); }
    public function bagWarehouse()  { return $this->belongsTo(\App\Models\Warehouse::class, 'bag_warehouse_id'); }
    public function exWarehouse()   { return $this->belongsTo(\App\Models\Warehouse::class, 'ex_warehouse_id'); }
    public function product()       { return $this->belongsTo(\App\Models\Product::class, 'product_id'); }
    public function exProduct()     { return $this->belongsTo(\App\Models\Product::class, 'ex_product_id'); }
    public function finishBag()     { return $this->belongsTo(\App\Models\FinishBag::class, 'finish_bag_id'); }
    public function exFinishBag()   { return $this->belongsTo(\App\Models\FinishBag::class, 'ex_finish_bag_id'); }
    public function creator()       { return $this->belongsTo(\App\Models\User::class, 'created_by'); }
    public function updater()       { return $this->belongsTo(\App\Models\User::class, 'updated_by'); }

    /* ---------- set created_by / updated_by automatically if columns exist ---------- */
    protected static function booted(): void
    {
        static::creating(function (self $m) {
            $uid = auth()->id();
            if ($uid) {
                if (\Schema::hasColumn($m->getTable(), 'created_by') && empty($m->created_by)) {
                    $m->created_by = $uid;
                }
                if (\Schema::hasColumn($m->getTable(), 'updated_by') && empty($m->updated_by)) {
                    $m->updated_by = $uid;
                }
            }
        });

        static::updating(function (self $m) {
            $uid = auth()->id();
            if ($uid && \Schema::hasColumn($m->getTable(), 'updated_by')) {
                $m->updated_by = $uid;
            }
        });
    }
}

