<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Area extends Model
{
    use SoftDeletes;

    protected $fillable = ['name', 'status', 'created_by', 'updated_by'];

    protected $casts = [
        'status' => 'integer',
    ];

    public function createdBy() { return $this->belongsTo(User::class, 'created_by'); }
    public function updatedBy() { return $this->belongsTo(User::class, 'updated_by'); }

    protected static function booted(): void
    {
        static::creating(function (self $m) {
            $m->created_by = auth()->id() ?? $m->created_by;
            $m->updated_by = auth()->id() ?? $m->updated_by;
            if ($m->status === null) $m->status = 1;
        });

        static::updating(function (self $m) {
            $m->updated_by = auth()->id() ?? $m->updated_by;
        });
    }
}
