<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccountYearClosingTrack extends Model
{
    protected $fillable = [
        'company_id',
        'starting_date',
        'closing_date',
        'owners_equity',
        'profit',
        'operating_income',
        'cost_of_good_sold',
        'non_operating_income',
        'operating_expenses',
        'non_operating_expenses',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'starting_date'           => 'date',
        'closing_date'            => 'date',
        'owners_equity'           => 'float',
        'profit'                  => 'float',
        'operating_income'        => 'float',
        'cost_of_good_sold'       => 'float',
        'non_operating_income'    => 'float',
        'operating_expenses'      => 'float',
        'non_operating_expenses'  => 'float',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
