<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccountSubsidiary extends Model
{
    protected $fillable = [
        'name',
        'account_group_id',
        'account_control_id',
        'company_id',
        'status',
        'is_deletable',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'status'       => 'integer', // use 'boolean' if strictly 0/1
        'is_deletable' => 'boolean',
    ];

    public function group(): BelongsTo
    {
        return $this->belongsTo(AccountGroup::class, 'account_group_id');
    }

    public function control(): BelongsTo
    {
        return $this->belongsTo(AccountControl::class, 'account_control_id');
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
