<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccountSetup extends Model
{
    protected $fillable = [
        'name',
        'company_id',
        'status',
        'is_deletable',
    ];

    protected $casts = [
        // If you treat these as booleans in your UI, casting helps:
        'status'       => 'integer', // or 'boolean' if 0/1 strictly means inactive/active
        'is_deletable' => 'boolean',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }
}

