<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccPurchaseReturnDetail extends Model
{
    protected $table = 'acc_purchase_return_details';

    protected $fillable = [
        'purchase_return_id',
        'purchase_detail_id',
        'product_id',
        'product_type',
        'quantity',
        'price',
        'subtotal',
    ];

    protected $casts = [
        'quantity' => 'decimal:2',
        'price'    => 'decimal:2',
        'subtotal' => 'decimal:2',
    ];

    public function purchaseReturn(): BelongsTo
    {
        return $this->belongsTo(AccPurchaseReturn::class, 'purchase_return_id');
    }

    public function purchaseDetail(): BelongsTo
    {
        return $this->belongsTo(AccPurchaseDetail::class, 'purchase_detail_id');
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}

