<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccPurchaseReturn extends Model
{
    protected $table = 'acc_purchase_returns';

    protected $fillable = [
        'date',
        'invoice_no',
        'purchase_id',
        'supplier_id',
        'company_id',
        'branch_id',
        'created_by',
        'updated_by',
        'total_return_amount',
        'total_exchange_amount',
        'total_amount',
        'total_discount',
        'total_payable',
        'total_paid_amount',
        'total_due_amount',
    ];

    protected $casts = [
        'total_return_amount'   => 'decimal:2',
        'total_exchange_amount' => 'decimal:2',
        'total_amount'          => 'decimal:2',
        'total_discount'        => 'decimal:2',
        'total_payable'         => 'decimal:2',
        'total_paid_amount'     => 'decimal:2',
        'total_due_amount'      => 'decimal:2',
        // add 'date' => 'date' if you later change the column type to DATE
    ];

    public function purchase(): BelongsTo
    {
        return $this->belongsTo(AccPurchase::class, 'purchase_id');
    }

    public function supplier(): BelongsTo
    {
        return $this->belongsTo(Supplier::class);
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function branch(): BelongsTo
    {
        return $this->belongsTo(Branch::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}

