<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccPurchaseExchangeDetail extends Model
{
    protected $table = 'acc_purchase_exchange_details';

    protected $fillable = [
        'purchase_return_id',
        'product_id',
        'quantity',
        'price',
        'subtotal',
    ];

    protected $casts = [
        'quantity' => 'decimal:2',
        'price'    => 'decimal:2',
        'subtotal' => 'decimal:2',
    ];

    // Adjust related class/table name if yours differs
    public function purchaseExchange(): BelongsTo
    {
        return $this->belongsTo(AccPurchaseExchange::class, 'purchase_return_id');
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}

