<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccPurchaseDetail extends Model
{
    protected $table = 'acc_purchase_details';

    protected $fillable = [
        'transaction_no',
        'product_id',
        'purchase_id',
        'quantity',
        'price',
        // 'amount' is virtual/generated by DB — do not mass assign
        'description',
    ];

    protected $casts = [
        'quantity' => 'float',
        'price'    => 'decimal:2',
        'amount'   => 'decimal:2', // readable cast; DB computes it
    ];

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function purchase(): BelongsTo
    {
        return $this->belongsTo(AccPurchase::class, 'purchase_id');
    }
}

