<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class AccPurchase extends Model
{
    protected $table = 'acc_purchases';

    protected $fillable = [
        'supplier_id',
        'date',
        'invoice_no',
        'qty_total',
        'qty_amount',
        'discount_amount',
        'total_amount',
        'previous_due',
        'payable_amount',
        'paid_amount',
        'due_amount',
        'company_id',
        'created_by',
        'updated_by',
        'sourceable_type',
        'sourceable_id',
        'source',
    ];

    protected $casts = [
        'qty_total'        => 'decimal:2',
        'qty_amount'       => 'decimal:2',
        'discount_amount'  => 'decimal:2',
        'total_amount'     => 'decimal:2',
        'previous_due'     => 'decimal:2',
        'payable_amount'   => 'decimal:2',
        'paid_amount'      => 'decimal:2',
        'due_amount'       => 'decimal:2',
        // add 'date' => 'date' if you later change column type to DATE
    ];

    public function supplier(): BelongsTo
    {
        return $this->belongsTo(Supplier::class);
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    // Polymorphic source model (e.g., Account, Production...)
    public function sourceable(): MorphTo
    {
        return $this->morphTo();
    }
}

