<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccDamage extends Model
{
    protected $table = 'acc_damages';

    protected $fillable = [
        'date',
        'invoice_no',
        'sale_return_id',
        'company_id',
        'branch_id',
        'created_by',
        'updated_by',
        'total_amount',
    ];

    protected $casts = [
        'total_amount' => 'decimal:2',
        // If you later switch `date` to a DATE column, add: 'date' => 'date',
    ];

    public function saleReturn(): BelongsTo
    {
        return $this->belongsTo(SaleReturn::class, 'sale_return_id');
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function branch(): BelongsTo
    {
        return $this->belongsTo(Branch::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
