<?php

namespace App\Http\Middleware;

use Closure;

class EnsureSuperAdmin
{
    public function handle($request, Closure $next)
    {
        if (!auth()->check() || !auth()->user()->is_superadmin) {
            abort(403, 'Only superadmin allowed.');
        }
        return $next($request);
    }
}