<?php

namespace App\Http\Middleware;

use Closure;

class AdminSidebarMenu
{
    public function handle($request, Closure $next)
    {
        if ($request->ajax()) {
            return $next($request);
        }

        $menu = [
            // --- Dashboard (single) ---
            ['label' => 'Superadmin', 'icon' => 'fa fas fa-tachometer-alt', 'route' => 'home'],
            ['label' => 'Home',       'icon' => 'fa fas fa-tachometer-alt', 'route' => 'home'],

            // --- User Access ---
            ['label'=>'User Access','icon'=>'fa fas fa-users','children'=>[
                ['label'=>'Users','route'=>'users.index'],
                ['label'=>'Roles','route'=>'roles.index'],
                ['label'=>'Permissions','route'=>'permissions.index'],
            ]],

            // --- Employee ---
            ['label'=>'Employee','icon'=>'fa fas fa-users','children'=>[
                ['label'=>'Designation List','route'=>'employee.designations'],
                ['label'=>'Department List','route'=>'employee.departments'],
                ['label'=>'Employee','route'=>'employee.index'],
            ]],

            /**
             * ========= Party breakup =========
             */
            ['label'=>'Suppliers','icon'=>'fas fa-truck','children'=>[
                ['label'=>'Create','route'=>'suppliers.create'],
                ['label'=>'List','route'=>'suppliers.index'],
            ]],

            ['label'=>'Customers','icon'=>'fa fas fa-address-book','children'=>[
                ['label'=>'Create','route'=>'customers.create'],
                ['label'=>'List','route'=>'customers.index'],
                ['label'=>'Party Types','children'=>[
                    ['label'=>'Create','route'=>'party_types.create'],
                    ['label'=>'List','route'=>'party_types.index'],
                ]],
            ]],
            // ========= End Party breakup =========

            // --- Products ---
            ['label'=>'Products','icon'=>'fa fas fa-cubes','children'=>[
                ['label'=>'Unit List','route'=>'products.units.index'],
                ['label'=>'Category List','route'=>'products.categories.index'],
                ['label'=>'Bag Type List','route'=>'products.bag-types.index'],
                ['label'=>'Warehouse Type List','route'=>'products.warehouse-types.index'],
                ['label'=>'Warehouse List','route'=>'products.warehouses.index'],
                ['label'=>'Dayar List','route'=>'products.dayars.index'],
                ['label'=>'Mill List','route'=>'products.mills.index'],
                ['label'=>'Area List','route'=>'products.areas.index'],
                ['label'=>'Raw Material List','route'=>'products.raw-materials.index'],
                ['label'=>'Finish Product List','route'=>'products.finish-products.index'],
                ['label'=>'Finish Bag List','route'=>'products.finish-bags.index'],
            ]],

            // --- Purchase ---
            ['label'=>'Purchase','icon'=>'fa fas fa-arrow-circle-down','children'=>[
                ['label'=>'Raw Material','children'=>[
                    ['label'=>'New Purchase','route'=>'purchase.raw_material.create'],
                    ['label'=>'Purchase List','route'=>'purchase.raw_material.index'],
                ]],
                ['label'=>'Finish Product','children'=>[
                    ['label'=>'New Purchase','route'=>'purchase.finish_product.create'],
                    ['label'=>'Purchase List','route'=>'purchase.finish_product.index'],
                ]],
                ['label'=>'Finish Bag','children'=>[
                    ['label'=>'New Purchase','route'=>'purchase.finish_bag.create'],
                    ['label'=>'Purchase List','route'=>'purchase.finish_bag.index'],
                ]],
                ['label'=>'Raw Bag','children'=>[
                    ['label'=>'New Purchase','route'=>'purchase.raw_bag.create'],
                    ['label'=>'Purchase List','route'=>'purchase.raw_bag.index'],
                ]],
            ]],

            // --- Bag Exchange ---
            ['label'=>'Bag Exchange','icon'=>'fas fa-exchange-alt','children'=>[
                ['label'=>'Create','route'=>'bag_exchange.create'],
                ['label'=>'List','route'=>'bag_exchange.index'],
            ]],

            // --- Stock Transfer (same style as others) ---
            [
                'label' => 'Stock Transfer',
                'icon'  => 'fa fas fa-truck',
                'children' => [
                    [
                        'label' => 'Raw Material',
                        'icon'  => 'fa fas fa-boxes',
                        'children' => [
                            // ✅ use the named routes from your route group
                            ['label' => 'Create', 'route' => 'stock-transfers.create', 'icon' => 'fa fas fa-plus-circle'],
                            ['label' => 'List',   'route' => 'stock-transfers.index',  'icon' => 'fa fas fa-list'],
                        ],
                    ],
                    [
                        'label' => 'Finish Product',
                        'icon'  => 'fa fas fa-box-open',
                        'children' => [
                            ['label' => 'Create', 'route' => 'transfer.finish-product.create', 'icon' => 'fa fas fa-plus-circle'],
                            ['label' => 'List',   'route' => 'transfer.finish-product.index',  'icon' => 'fa fas fa-list'],
                        ],
                    ],
                ],
            ],

            // --- Adjustment ---
            ['label'=>'Adjustment','icon'=>'fa fas fa-database','children'=>[
                ['label'=>'Raw Product','children'=>[
                    ['label'=>'Create','route'=>'adjustment.raw_product.create'],
                    ['label'=>'List','route'=>'adjustment.raw_product.index'],
                ]],
                ['label'=>'Finish Product','children'=>[
                    ['label'=>'Create','route'=>'adjustment.finish_product.create'],
                    ['label'=>'List','route'=>'adjustment.finish_product.index'],
                ]],
                ['label'=>'Finish Bag','children'=>[
                    ['label'=>'Create','route'=>'adjustment.finish_bag.create'],
                    ['label'=>'List','route'=>'adjustment.finish_bag.index'],
                ]],
                ['label'=>'Raw Bag','children'=>[
                    ['label'=>'Create','route'=>'adjustment.raw_bag.create'],
                    ['label'=>'List','route'=>'adjustment.raw_bag.index'],
                ]],
                ['label'=>'Raw Bag Opening','children'=>[
                    ['label'=>'Create Raw Bag','route'=>'adjustment.raw_bag_opening.create'],
                    ['label'=>'Bag Opening List','route'=>'adjustment.raw_bag_opening.index'],
                ]],
                ['label'=>'Gs Adjustment','children'=>[
                    ['label'=>'New Adjustment','route'=>'adjustment.new_gs.create'],
                    ['label'=>'Adjustment List','route'=>'adjustment.new_gs.index'],
            ]],
            ]],

            // --- Order ---
            ['label'=>'Order','icon'=>'fas fa-shopping-cart','children'=>[
                ['label'=>'Create','route'=>'order.create'],
                ['label'=>'List','route'=>'order.index'],
            ]],

            // --- Order Delivery ---
            ['label'=>'Order Delivery','icon'=>'fas fa-truck','children'=>[
                ['label'=>'Create','route'=>'order_delivery.create'],
                ['label'=>'List','route'=>'order_delivery.index'],
            ]],

            // --- Sales ---
            ['label'=>'Sales','icon'=>'fas fa-balance-scale','children'=>[
                ['label'=>'Create','route'=>'sales.create'],
                ['label'=>'List','route'=>'sales.index'],
            ]],

            // --- Sales Delivery ---
            ['label'=>'Sales Delivery','icon'=>'fas fa-truck-moving','children'=>[
                ['label'=>'Create','route'=>'sales_delivery.create'],
                ['label'=>'List','route'=>'sales_delivery.index'],
            ]],

            // --- Issue RM ---
            ['label'=>'Issue Raw Material','icon'=>'fas fa-cubes','children'=>[
                ['label'=>'Create','route'=>'issue_rm.create'],
                ['label'=>'List','route'=>'issue_rm.index'],
            ]],

            // --- Finish Production ---
            ['label'=>'Finish Production','icon'=>'fas fa-industry','children'=>[
                ['label'=>'Create','route'=>'production.create'],
                ['label'=>'List','route'=>'production.index'],
            ]],

            // --- Return ---
            ['label'=>'Return','icon'=>'fas fa-undo','children'=>[
                ['label'=>'Raw Purchase Return','children'=>[
                    ['label'=>'Create','route'=>'return.raw_purchase.create'],
                    ['label'=>'List','route'=>'return.raw_purchase.index'],
                ]],
                ['label'=>'Finish Purchase Return','children'=>[
                    ['label'=>'Create','route'=>'return.finish_purchase.create'],
                    ['label'=>'List','route'=>'return.finish_purchase.index'],
                ]],
                ['label'=>'Sales Return','children'=>[
                    ['label'=>'Create','route'=>'return.sales.create'],
                    ['label'=>'List','route'=>'return.sales.index'],
                ]],
                ['label'=>'Order Return','children'=>[
                    ['label'=>'Create','route'=>'return.order.create'],
                    ['label'=>'List','route'=>'return.order.index'],
                ]],
                ['label'=>'Return Bag','children'=>[
                    ['label'=>'Create','route'=>'return.bag.create'],
                    ['label'=>'List','route'=>'return.bag.index'],
                ]],
            ]],

            // --- Labour Cost ---
            ['label'=>'Labour Cost','icon'=>'fas fa-money-check-alt','children'=>[
                ['label'=>'Create','route'=>'labour.create'],
                ['label'=>'List','route'=>'labour.index'],
            ]],

            // --- Payment & Due ---
            ['label'=>'Payment & Due','icon'=>'fas fa-university','children'=>[
                ['label'=>'Customer Due','children'=>[
                    ['label'=>'Collect Due','route'=>'payment.collect_due'],
                    ['label'=>'Collection List','route'=>'payment.collection_list'],
                ]],
                ['label'=>'Supplier Payment','children'=>[
                    ['label'=>'Create','route'=>'payment.supplier.create'],
                    ['label'=>'List','route'=>'payment.supplier.index'],
                ]],
            ]],

            // --- Reports ---
            ['label'=>'Reports','icon'=>'fas fa-file-alt','children'=>[
                ['label'=>'Raw Material','children'=>[
                    ['label'=>'Stock In Hand','route'=>'reports.raw_material.stock_in_hand'],
                    ['label'=>'Ledger','route'=>'reports.raw_material.ledger'],
                    ['label'=>'Mal Khotiyan','route'=>'reports.raw_material.mal_khotiyan'],
                ]],
                ['label'=>'Finish Product','children'=>[
                    ['label'=>'Production Stock','route'=>'reports.finish_product.production_stock'],
                    ['label'=>'Production Ledger','route'=>'reports.finish_product.production_ledger'],
                    ['label'=>'Purchase Stock','route'=>'reports.finish_product.purchase_stock'],
                    ['label'=>'Purchase Ledger','route'=>'reports.finish_product.purchase_ledger'],
                ]],
                ['label'=>'Finish Bag','children'=>[
                    ['label'=>'Stock In Hand','route'=>'reports.finish_bag.stock_in_hand'],
                    ['label'=>'Ledger','route'=>'reports.finish_bag.ledger'],
                ]],
                ['label'=>'Raw Bag','children'=>[
                    ['label'=>'Supplier In Hand','route'=>'reports.raw_bag.supplier_in_hand'],
                    ['label'=>'Supplier Bag Ledger','route'=>'reports.raw_bag.supplier_bag_ledger'],
                    ['label'=>'Empty bag Stock','route'=>'reports.raw_bag.empty_bag_stock'],
                    ['label'=>'Ledger','route'=>'reports.raw_bag.ledger'],
                ]],
                ['label'=>'Sales Report','children'=>[
                    ['label'=>'Finish Product','route'=>'reports.sales.finish_product'],
                    ['label'=>'Production Product','route'=>'reports.sales.production_product'],
                    ['label'=>'Monthly Sale','route'=>'reports.sales.monthly_sale'],
                ]],
                ['label'=>'Order Report','children'=>[
                    ['label'=>'Finish Product','route'=>'reports.order.finish_product'],
                    ['label'=>'Production Product','route'=>'reports.order.production_product'],
                    ['label'=>'Monthly Order','route'=>'reports.order.monthly_order'],
                ]],
                ['label'=>'Purchase Report','children'=>[
                    ['label'=>'Raw Product','route'=>'reports.purchase.raw_product'],
                    ['label'=>'Finish Product','route'=>'reports.purchase.finish_product'],
                    ['label'=>'Finish Bag','route'=>'reports.purchase.finish_bag'],
                    ['label'=>'Raw Bag','route'=>'reports.purchase.raw_bag'],
                ]],
                ['label'=>'Damage Report','children'=>[
                    ['label'=>'Raw Product','route'=>'reports.damage.raw_product'],
                    ['label'=>'Finish Product','route'=>'reports.damage.finish_product'],
                    ['label'=>'Raw Bag','route'=>'reports.damage.raw_bag'],
                    ['label'=>'Finish Bag','route'=>'reports.damage.finish_bag'],
                ]],
                ['label'=>'Customer Ledger','route'=>'reports.customer_ledger'],
                ['label'=>'Supplier Ledger','route'=>'reports.supplier_ledger'],
                ['label'=>'Supplier Report','route'=>'reports.supplier_report'],
                ['label'=>'Customer Performance','route'=>'reports.customer_performance'],
                ['label'=>'Executive Performance','route'=>'reports.executive_performance'],
                ['label'=>'Production Cost Report','route'=>'reports.production_cost'],
                ['label'=>'Labour Cost Report','route'=>'reports.labour_cost'],
                ['label'=>'Order Return Report','route'=>'reports.order_return'],
                ['label'=>'Sale Return Report','route'=>'reports.sale_return'],
                ['label'=>'Dayar Report','route'=>'reports.dayar'],
                ['label'=>'Mill report','route'=>'reports.mill'],
                ['label'=>'Daily report','route'=>'reports.daily'],
                ['label'=>'Day Book','route'=>'reports.day_book'],
                ['label'=>'Cash Book','route'=>'reports.cash_book'],
            ]],

            // --- Account ---
            ['label'=>'Account','icon'=>'fas fa-landmark','children'=>[
                ['label'=>'Account Mapping','route'=>'account.mapping'],
                ['label'=>'Account Summary','route'=>'account.summary'],
            ]],

            // --- Global Setting ---
            ['label'=>'Global Setting','icon'=>'fas fa-gear','children'=>[
                ['label'=>'Business Settings','route'=>'settings.business'],
                ['label'=>'Invoice Settings','route'=>'settings.invoice'],
                ['label'=>'Printers','route'=>'settings.printers'],
                ['label'=>'Payment Methods','route'=>'settings.payments'],
                ['label'=>'Currencies','route'=>'settings.currencies'],
            ]],
        ];

        view()->share('ARM_MENU', $menu);

        return $next($request);
    }
}
