<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    // GET /profile -> profile.edit
    public function edit(Request $request)
    {
        $user = $request->user(); // Auth::user()
        return view('profile.edit', compact('user'));
    }

    // PUT /profile -> profile.update
    public function update(Request $request)
    {
        $user = $request->user();

        $validated = $request->validate([
            'name'  => ['required','string','max:255'],
            'email' => [
                'required','email','max:255',
                Rule::unique('users','email')->ignore($user->id),
            ],
            // নতুন পাসওয়ার্ড দিলে confirm করতে হবে
            'password' => ['nullable','min:8','confirmed'],
        ]);

        $user->name  = $validated['name'];
        $user->email = $validated['email'];

        if (!empty($validated['password'])) {
            $user->password = Hash::make($validated['password']);
        }

        $user->save();

        return back()->with('status', 'Profile updated successfully.');
    }
}

