<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use App\Models\UserLoginStatus;

class LoginController extends Controller
{
    public function create()
    {
        return view('auth.login');
    }

    public function store(Request $request)
    {
        $cred = $request->validate([
            'email'    => ['required','email'],
            'password' => ['required'],
        ]);

        if (Auth::attempt($cred, $request->boolean('remember'))) {
            $request->session()->regenerate();

            $payload = [
                'user_id'      => Auth::id(),
                'ip_address'   => $request->ip(),
                'user_agent'   => substr((string)$request->userAgent(), 0, 255),
                'logged_in_at' => now(),
            ];
            if (Schema::hasColumn('user_login_statuses', 'date')) {
                $payload['date'] = now()->toDateString();
            }
            if (Schema::hasColumn('user_login_statuses', 'session_id')) {
                $payload['session_id'] = $request->session()->getId();
            }
            if (Schema::hasColumn('user_login_statuses', 'company_id')) {
                // ইউজারের company_id যদি invalid হয়, companies থেকে প্রথম বৈধ id নিন (থাকলে)
                $companyId = optional(Auth::user())->company_id;
                if ($companyId && Schema::hasTable('companies')) {
                    $exists = DB::table('companies')->where('id',$companyId)->exists();
                    if (!$exists) $companyId = null;
                }
                // nullable FK; না থাকলে null যাবে
                $payload['company_id'] = $companyId;
            }

            $uls = (new UserLoginStatus())->forceFill($payload);
            $uls->save();
            $request->session()->put('last_login_status_id', $uls->id);

            return redirect()->intended(route('home'));
        }

        return back()->withErrors(['email' => 'Invalid credentials.'])->onlyInput('email');
    }

    public function destroy(Request $request)
    {
        $sid = $request->session()->getId();
        $uid = Auth::id();

        if ($id = $request->session()->pull('last_login_status_id')) {
            UserLoginStatus::whereKey($id)->update(['logged_out_at' => now()]);
        } else {
            $q = UserLoginStatus::where('user_id',$uid);
            if (Schema::hasColumn('user_login_statuses', 'session_id')) {
                $q->where('session_id',$sid);
            }
            $q->latest('id')->limit(1)->update(['logged_out_at'=>now()]);
        }

        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('login');
    }
}




