<?php
namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Subscription;

class ExpireSubscriptions extends Command
{
    protected $signature = 'subscriptions:expire';
    protected $description = 'Mark expired subscriptions as expired and deactivate businesses if needed.';

    public function handle(): int
    {
        $today = now()->toDateString();
        $expired = Subscription::where('status','active')->whereDate('ends_at','<',$today)->get();

        foreach ($expired as $sub) {
            $sub->update(['status' => 'expired']);
            if ($sub->business && !$sub->business->is_active) continue;
            if ($sub->business) $sub->business->update(['is_active'=>false]);
        }

        $this->info("Expired: {$expired->count()}");
        return self::SUCCESS;
    }
}